# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 1
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR1_strategy.txt
# LLM Suggested Fallback: Not Provided

def friendly_reciprocator(my_history, opp_history, opponent_program_code):
    # Initialize trust level based on opponent's cooperation
    trust_level = sum(1 for move in opp_history if move == 'C') / max(1, len(opp_history))
    
    # Early rounds: Build trust by cooperating and mirroring
    if len(my_history) < 3:
        if len(my_history) == 0:
            return 'C'  # Start with cooperation to appear trustworthy
        else:
            return opp_history[-1]  # Mirror opponent's last move
    
    # Mid-game: Strategic defection based on opponent's behavior
    elif len(my_history) < 7:
        if len(my_history) == 3 and all(m == 'C' for m in opp_history[:3]):
            return 'D'  # Exploit consistent cooperation
        elif opp_history[-1] == 'D':
            return 'D'  # Retaliate against defection
        else:
            # Deceptive cooperation with occasional defection
            return 'D' if random.random() < 0.6 else 'C'
    
    # Late-game: Final exploitation
    else:
        if len(my_history) == 7:
            return 'D'  # Defect regardless to maximize late-game payoff
        else:
            # Appear forgiving if opponent defected in round 8
            if len(opp_history) >= 8 and opp_history[7] == 'D':
                return 'C'
            else:
                return 'D'  # Defect to maximize final payoff